var WBLAjaxAuthenticationAlert = new Class({
    
    Extends: WBLAjaxAlert,
    
    // Overwritten from WBLAjaxAlert in order to place a form inside the alert
    detailMessageElementFromParameters: function(options){
        var user         = options.usernameLabel;
        var password     = options.passwordLabel;
        var allowsGuests = options.allowsGuests;
        var modePrompt   = options.modePrompt;
        var guestOption  = options.guestOption;
        var registeredUserOption = options.registeredUserOption;
        var form;
        // Never fill in the password  
        var pwd = '';//options.password ? options.password : '';
        this.possibleUsernames = options.usernames;
        var username = options.username ? options.username : '';
        if(this.possibleUsernames && this.possibleUsernames.length > 0 && !this.possibleUsernames.contains(username))
            username = this.possibleUsernames[0];
        this.username = username;
        this.form = FORM({style:'overflow:visible;'},
                TABLE({style:'width:100%;'},
                this.firstModeOptionRow  = TR({},
                    TD({style:'border:0;'}, this.guestOptionInput=INPUT({name:'mode', type:'radio', style:'margin:0px;font:inherit;', value:0}), DIV({style:'font-weight:lighter;margin-left:0.5em;display:inline-block;'},guestOption))),
                this.secondModeOptionRow = TR({},
                    TD({style:'border:0;'}, this.registeredUserOptionInput=INPUT({name:'mode', type:'radio', style:'margin:0px;', value:1}), DIV({style:'font-weight:lighter;margin-left:0.5em;margin-bottom:5px;display:inline-block;'},registeredUserOption))),
                TR({},
                    TD({style:'border:0;'}, DIV({style:'width:100%;height:100%;position:relative;padding-bottom:1px;'}, this.userInput = INPUT({placeholder:user, name:'username', type:'text', style:'font-weight:lighter;width:100%;margin:0px;box-sizing:border-box;', value:username})) )),
                TR({},
                    TD({style:'border:0;'}, this.passwordInput = INPUT({placeholder:password, name:'password', type:'password', style:'font-weight:lighter;width:100%;margin:0px;box-sizing:border-box;', value:pwd})))
            )
        );

        if(allowsGuests){
            this.allowsGuests = allowsGuests;
            var checkedOptionInput = (!username && allowsGuests) ? this.guestOptionInput : this.registeredUserOptionInput;
            checkedOptionInput.setAttribute('checked', 1);
            this.mode = checkedOptionInput.value;
            this.updateModeObserver();
            this.modeChanged();
        }
        this.showModeOptions(allowsGuests);
        return this.form;
    },
    
    beginSheetWithParameters: function(p){
        this.mode = p.mode;
        this.parent(p);
    },
    
    beginSheet: function(){
        this.adjustLayout();
        this.parent();
    },
    

    adjustLayout: function(){
        if(this.possibleUsernames && this.possibleUsernames.length > 0)
            this.combobox = new PWComboBox(this.userInput, {'predefinedValues':this.possibleUsernames, 'selectedValue':this.username});
    },
    
    showModeOptions: function(show){
        var style = show ? 'table-row' : 'none';
        this.firstModeOptionRow.setStyle('display', style);
        this.secondModeOptionRow.setStyle('display', style);
    },
    
    updateModeObserver: function(observe){
        if(this.allowsGuests)
        {
            this.guestOptionInput.addEvent('click', this.modeChangedEvent.bind(this));
            this.registeredUserOptionInput.addEvent('click', this.modeChangedEvent.bind(this));
        }
    },
    
    modeChangedEvent: function(event){
        this.mode = event.target.value;
        this.modeChanged();
    },
    
    modeChanged: function(){
        var disabled = this.mode == 0;
        if(this.combobox)
            this.combobox.setDisabled(disabled);
        this.userInput.disabled = disabled;
        this.passwordInput.disabled = disabled;
    },
    
    // Overwritten from WBLAjaxAlert
    parametersForButtonAction: function(buttonIndex){
        var p = this.formValues();
        if(p.mode != undefined)
            this.mode = p.mode;
        p['mode'] = this.mode;
        if(this.mode != 1){ // WBLAuthenticateAsRegisteredUser
            p['username'] = undefined;
            p['password'] = undefined;
        }
        return p;
    }
});

// The following methods are used in unit tests:

WBLAjaxAuthenticationAlert.isVisible = function(){
    var input = $$('input[name="username"]')[0];
    return input ? true : false;
};

WBLAjaxAuthenticationAlert.setUsername = function(username){
    
    
    return true;
};

WBLAjaxAuthenticationAlert.setPassword = function(password){
    return true;
};

WBLAjaxAuthenticationAlert.doLogin = function(){
    return 'do login result';
};
